package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.health.dto.HealthHistoryRecordDTO;
import gov.va.med.mhv.health.dto.OtherHealthIssueDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.web.form.bean.HealthHistoryRecord;
import gov.va.med.mhv.health.web.form.bean.OtherHealthIssue;
import gov.va.med.mhv.health.web.util.HealthHistoryRecordComparator;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class FamilyController extends AbstractController {

	private static final long serialVersionUID = 981887530734048333L;

	private static Logger log = LogManager.getLogger(FamilyController.class);
	private List<HealthHistoryRecord> healthHistoryRecords = new ArrayList<HealthHistoryRecord>();
	private DataTable hrTable;
	private DataTable issueTable;
	private HealthHistoryRecord selectedHealthHistoryRecord = new HealthHistoryRecord();
	private HealthHistoryRecord newHealthHistoryRecord = new HealthHistoryRecord();
	private HealthHistoryRecord selfHealthHistoryRecord = new HealthHistoryRecord();
	private static final String HEALTH_HISTORY = "healthHistory";
	private static final String DELETE_HEALTH_HISTORY_RECORD = "deleteHealthHistoryRecord";
	private static final String DELETE_HEALTH_ISSUE_RECORD = "deleteHealthIssueRecord";
	private static final String HEALTH_HISTORY_BY_ID = "healthHistoryRecordByid";
	private static final String ADD_HEALTH_HISTORY_RECORD = "addFamilyDisplay";
	private static final String EDIT_HEALTH_HISTORY_RECORD = "editFamilyDisplay";
	private boolean missingFirstName=false;
	private boolean missingRelationship=false;

	// private List<OtherHealthIssueDTO> otherHealthIssues = new
	// ArrayList<OtherHealthIssueDTO>(0);
	private String otherHealthIssue = "";
	private String returnPage = "familyList";
	private boolean addedOtherIssues = false;

	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		issueTable = (DataTable) FacesContext.getCurrentInstance()
				.getViewRoot().findComponent("familyForm:healthHistoryList");
		if (!FacesContext.getCurrentInstance().isPostback()) {
			resetMessages();
			healthHistoryRecords = findHealthHistoryRecords(userprofileId);
			setRowsPerPage(10);
		} else {
			if (sortColumn != null && sortBy != null) {
				issueTable.setValueExpression("sortBy", sortColumn);
				issueTable.setSortOrder(sortBy);
			}
		}
	}

	public void onSort(SortEvent event) {
		sortColumn = event.getSortColumn().getValueExpression("sortBy");
		sortBy = event.isAscending() ? "ascending" : "descending";
	}

	private List<HealthHistoryRecord> findHealthHistoryRecords(
			Long userprofileId) {
		List<HealthHistoryRecord> dtoList = new ArrayList<HealthHistoryRecord>();
		List<HealthHistoryRecord> newFilteredHHList = new ArrayList<HealthHistoryRecord>();

		Reader responseReader = null;
		try {
			Gson gson = getGsonTimeStamp();
			WebClient client = getWebClient().path(HEALTH_HISTORY)
					.path(userprofileId).accept(CONTENT_TYPE);
			Response webserviceResponse = client.get();
			if (webserviceResponse.getStatus() == 200) {
				responseReader = new InputStreamReader((InputStream) client
						.get().getEntity());
				ResponseUtil response = gson.fromJson(responseReader,
						ResponseUtil.class);
				if (response.isSuccess()) {
					String healthHistoryRecordJson = gson.toJson(response
							.getPojoObject());
					Type type = new TypeToken<List<HealthHistoryRecord>>() {
					}.getType();
					dtoList = gson.fromJson(healthHistoryRecordJson, type);
					// Filter to get self record details
					setSelfRecord(dtoList);
				} else {
					log.error("Error in Find Health History Records");
					WebServiceClientUtil.showErrorMessage();
				}
			} else {
				log.error(WebServiceClientUtil.formatErrorMessage(client,
						webserviceResponse));
				WebServiceClientUtil.showErrorMessage();
			}
		} catch (Exception e) {
			log.error("Error in Find Health History Records:", e);
			WebServiceClientUtil.showErrorMessage();
			dtoList = new ArrayList<HealthHistoryRecord>();
		} finally {
			responseReader = null;
		}
		
		if (dtoList!=null && dtoList.size() > 0) {
			Collections.sort(dtoList,new HealthHistoryRecordComparator() );
				
				//Display Self First
				for (HealthHistoryRecord record: dtoList) {
					if (record!=null) {
						if (record.getRelationshipType().equalsIgnoreCase("Self")) {
							newFilteredHHList.add(record);
							break;
						}
					}
				}
				//Display everything but self after
				for (HealthHistoryRecord record: dtoList) {
					if (record!=null) {
						if (!record.getRelationshipType().equalsIgnoreCase("Self")) {
							newFilteredHHList.add(record);
						}
					}
				}
		}
		
		dtoList=newFilteredHHList;
		return dtoList;
	}

	public String addOtherHealthIssue() {
		missingFirstName=false;
		missingRelationship=false;
		String outcome = null;

		resetMessages();

		String hhrid = FacesContext.getCurrentInstance().getExternalContext()
				.getRequestParameterMap().get("hhrid");
		String returnPage = FacesContext.getCurrentInstance()
				.getExternalContext().getRequestParameterMap()
				.get("returnPage");

		HealthHistoryRecord healthRecord = null;
		if (hhrid != null) {
			healthRecord = getSelectedHealthHistoryRecord();
		} else {
			healthRecord = getNewHealthHistoryRecord();
		}

		if (hhrid == null && addedOtherIssues) {
			healthHistoryRecords = findHealthHistoryRecords(userprofileId);
			if (healthHistoryRecords.size() > 0) {
				int lastIndex = healthHistoryRecords.size() - 1;
				Long id = healthHistoryRecords.get(lastIndex).getId();
				healthRecord.setId(id);
				log.debug("Health Record id" + id);
			}

		}
		
		if (healthRecord.getFirstName()==null || healthRecord.getFirstName().isEmpty()) {
			missingFirstName=true;
		}
		
		if (healthRecord.getRelationship()==null || healthRecord.getRelationship().isEmpty()) {
			missingRelationship=true;
		}
		
		if (otherHealthIssue != null && otherHealthIssue.trim().length() > 0) {
			OtherHealthIssueDTO newHealthIssueDTO = new OtherHealthIssue();
			newHealthIssueDTO.setIssue(otherHealthIssue);
			newHealthIssueDTO.setOplock(1);
			healthRecord.getOtherHealthIssues().add(newHealthIssueDTO);
			outcome = save();
			outcome = returnPage;
			addedOtherIssues = true;
		} else {
		
			if(missingFirstName) {
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"First Name is a required field.",
								"firstName"));
				}
			
			if(missingRelationship) {
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"Relationship is a required field.",
								"family"));
				}
			
			// validation error
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Other Health Issue is a required field.",
							"OtherHealthIssueRequired"));
			healthRecord.setRelationship("");
			return outcome;
		}
		return outcome;
	}

	public String showDetail(HealthHistoryRecord healthHistoryRecord) {
		resetMessages();
		setOtherHealthIssue("");
		returnPage = "family";
		selectedHealthHistoryRecord = healthHistoryRecord;
		// setOtherHealthIssues(selectedHealthHistoryRecord.getOtherHealthIssues());
		return "family";
	}

	public String editDisplay(HealthHistoryRecord healthHistoryRecord) {
		resetMessages();
		setOtherHealthIssue("");
		missingFirstName=false;
		missingRelationship=false;
		selectedHealthHistoryRecord = healthHistoryRecord;
		// setOtherHealthIssues(selectedHealthHistoryRecord.getOtherHealthIssues());
		return "editFamilyDisplay";
	}

	public String deleteDisplay(HealthHistoryRecord healthHistoryRecord) {
		resetMessages();
		setOtherHealthIssue("");
		selectedHealthHistoryRecord = healthHistoryRecord;
		// setOtherHealthIssues(selectedHealthHistoryRecord.getOtherHealthIssues());
		return "deleteFamilyDisplay";
	}

	public String backToList() {
		resetMessages();
		setOtherHealthIssue("");
		// setOtherHealthIssues(selectedHealthHistoryRecord.getOtherHealthIssues());
		return "familyList";
	}

	public String returnToCallingPage() {
		resetMessages();
		returnPage = (null != returnPage && returnPage.trim().length() > 0) ? returnPage
				: "familyList";
		return returnPage;
	}

	public String deleteIssueDisplay() {

		String outcome = FacesContext.getCurrentInstance().getExternalContext()
				.getRequestParameterMap().get("returnPage");
		Reader responseReader = null;
		String strIssueId = FacesContext.getCurrentInstance()
				.getExternalContext().getRequestParameterMap().get("issueId");

		if (strIssueId != null && !strIssueId.isEmpty()) {
			Long issueId = Long.valueOf(strIssueId);

			try {
				Gson gson = getGsonTimeStamp();
				WebClient client = getWebClient()
						.path(DELETE_HEALTH_ISSUE_RECORD).path(issueId)
						.accept(CONTENT_TYPE);

				responseReader = new InputStreamReader((InputStream) client
						.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader,
						ResponseUtil.class);

				if (response.isSuccess()) {
					String healthHistoryRecordJson = gson.toJson(response
							.getPojoObject());

					if (null != outcome
							&& outcome.equalsIgnoreCase("addFamilyDisplay")) {
						newHealthHistoryRecord = gson.fromJson(
								healthHistoryRecordJson,
								HealthHistoryRecord.class);
					} else if (outcome.equalsIgnoreCase("editFamilyDisplay")) {
						selectedHealthHistoryRecord = gson.fromJson(
								healthHistoryRecordJson,
								HealthHistoryRecord.class);
					}
				} else {
					log.error("Error in deleting Health Issue Record By id");
					WebServiceClientUtil.showErrorMessage();
				}
			} catch (Exception e) {
				log.error("Error in deleting Health Issue Record By id : ", e);
				WebServiceClientUtil.showErrorMessage();
			} finally {
				responseReader = null;
				
			}
		} else {
			

			String strIssueName = FacesContext.getCurrentInstance()
					.getExternalContext().getRequestParameterMap().get("issueName");
			List<OtherHealthIssueDTO> newList = new ArrayList<OtherHealthIssueDTO>();
			String pageName = FacesContext.getCurrentInstance()
					.getExternalContext().getRequestParameterMap().get("returnPage");
			if (pageName.equalsIgnoreCase("editFamilyDisplay")) {
				for (OtherHealthIssueDTO otherIssue: selectedHealthHistoryRecord.getOtherHealthIssues()) {
					if (!strIssueName.equals(otherIssue.getIssue())) {
						newList.add(otherIssue);
					}
				}	
			} else {
			for (OtherHealthIssueDTO otherIssue: newHealthHistoryRecord.getOtherHealthIssues()) {
				if (!strIssueName.equals(otherIssue.getIssue())) {
					newList.add(otherIssue);
				}
			}
			}
			
			if (pageName.equalsIgnoreCase("editFamilyDisplay")) {
				selectedHealthHistoryRecord.setOtherHealthIssues(newList);
			} else {
				newHealthHistoryRecord.setOtherHealthIssues(newList);
			}
			otherHealthIssue="";
			

		}

		return outcome;
	}

	public String addDisplay() {
		resetMessages();
		setOtherHealthIssue("");
		missingRelationship=false;
		missingFirstName=false;
		addedOtherIssues = false;
		// setOtherHealthIssues(new ArrayList<OtherHealthIssueDTO>(0));
		newHealthHistoryRecord = new HealthHistoryRecord();
		return "addFamilyDisplay";
	}

	// TODO: change the navigation handler
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newHealthHistoryRecord = new HealthHistoryRecord();
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication()
				.getNavigationHandler()
				.handleNavigation(context, null,
						"../heartrate/addHRDisplay.xhtml");
		return null;
	}

	// TODO:change the navigation handler
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String hhid = FacesContext.getCurrentInstance().getExternalContext()
				.getRequestParameterMap().get("hhid");
		if (hhid != null) {
			Long id = Long.valueOf(hhid);
			selectedHealthHistoryRecord = findHealthHistoryRecordById(id);
		}
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler()
				.handleNavigation(context, null, "../family/family.xhtml");
		return null;
	}

	private HealthHistoryRecord findHealthHistoryRecordById(Long id) {
		HealthHistoryRecord dto = null;
		Reader responseReader = null;
		try {
			Gson gson = getGsonTimeStamp();
			WebClient client = getWebClient().path(HEALTH_HISTORY_BY_ID)
					.path(id).accept(CONTENT_TYPE);
			Response webserviceResponse = client.get();
			if (webserviceResponse.getStatus() == 200) {
				ResponseUtil response = gson.fromJson(responseReader,
						ResponseUtil.class);
				if (response.isSuccess()) {
					String healthHistoryRecordJson = gson.toJson(response
							.getPojoObject());
					dto = gson.fromJson(healthHistoryRecordJson,
							HealthHistoryRecord.class);
				} else {
					log.error("Error in Find Health History Record By id");
					WebServiceClientUtil.showErrorMessage();
				}
			} else {
				log.error(WebServiceClientUtil.formatErrorMessage(client,
						webserviceResponse));
				WebServiceClientUtil.showErrorMessage();
			}
		} catch (Exception e) {
			log.error("Error in Find  Health History Record By id:", e);
			WebServiceClientUtil.showErrorMessage();
		} finally {
			responseReader = null;
		}
		return dto;
	}

	public String delete() {
		// Refactor to check for status 200 like the logic for find methods did
		// not appear to work. Perhaps this is because it uses a delete instead
		// of a get.

		String outcome = null;
		Reader responseReader = null;
		String hhid = FacesContext.getCurrentInstance().getExternalContext()
				.getRequestParameterMap().get("hhrid");
		try {
			if (hhid != null) {
				Long id = Long.valueOf(hhid);
				Gson gson = getGsonTimeStamp();
				WebClient client = getWebClient()
						.path(DELETE_HEALTH_HISTORY_RECORD).path(id)
						.accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client
						.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader,
						ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Health History Record",
							response.getFailureMessage());

					WebServiceClientUtil.showErrorMessage();

				} else {
					deleteMessage = true;
					healthHistoryRecords = findHealthHistoryRecords(userprofileId);
					outcome = "familyList";
				}
			}
		} catch (Exception e) {
			log.error("Failed to Delete Health History Record", e);
			WebServiceClientUtil.showErrorMessage();

		} finally {
			responseReader = null;
		}
		return outcome;
	}

	public String save() {
		String outcome = null;
		Reader responseReader = null;
		try {
			ResponseUtil response = saveHealthHistoryRecord(responseReader);
			if (response.isSuccess()) {
				outcome = "familyList";
				saveMessage = true;
				healthHistoryRecords = findHealthHistoryRecords(userprofileId);
			}
		} catch (Exception e) {
			log.error("Failed to Save Health History Record", e);

			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							ERR_PRCS_RQST, ERR_PRCS_RQST));
		} finally {
			responseReader = null;
		}
		return outcome;
	}

	public ResponseUtil saveHealthHistoryRecord(Reader responseReader) {
		// Refactor to check for status 200 like the logic for find methods did
		// not appear to work. Perhaps this is because it uses a delete instead
		// of a get.
		missingFirstName=false;
		missingRelationship=false;
		String hhrid = FacesContext.getCurrentInstance().getExternalContext()
				.getRequestParameterMap().get("hhrid");
		HealthHistoryRecord healthRecord = null;
		if (hhrid != null && hhrid.trim().length() > 0) {
			healthRecord = getSelectedHealthHistoryRecord();
			// selectedHealthHistoryRecord = (HealthHistoryRecord)
			// hrTable.getRowData();
		} else {
			healthRecord = getNewHealthHistoryRecord();
		}
		
		if (healthRecord.getFirstName()==null || healthRecord.getFirstName().isEmpty()) {
			missingFirstName=true;
		}
		
		if (healthRecord.getRelationship()==null || healthRecord.getRelationship().isEmpty()) {
			missingRelationship=true;
		}

		if (hhrid == null && addedOtherIssues) {
			healthHistoryRecords = findHealthHistoryRecords(userprofileId);
			if (healthHistoryRecords.size() > 0) {
				int lastIndex = healthHistoryRecords.size() - 1;
				Long id = healthHistoryRecords.get(lastIndex).getId();
				healthRecord.setId(id);
				log.debug("Health Record id" + id);
			}

		}
		if (log.isDebugEnabled()) {
			log.debug("saveHealthHistoryRecord : healthRecord.getId() : "
					+ healthRecord.getId());
		}

		Gson gson = getGsonTimeMilli();
		WebClient client = getWebClient().path(HEALTH_HISTORY)
				.accept(CONTENT_TYPE).type(CONTENT_TYPE);

		healthRecord = prepareHealthHistoryRecord(healthRecord);
		String healthRecordJson = gson.toJson(healthRecord);
		responseReader = new InputStreamReader((InputStream) client.post(
				healthRecordJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader,
				ResponseUtil.class);

		if (!response.isSuccess()) {
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
			
				//Server side and required validation conflicts with each other. This code needs to be there to allow all validations to occur.
				
				FacesContext.getCurrentInstance().addMessage(
						entry.getKey(),
						new FacesMessage(FacesMessage.SEVERITY_ERROR, entry
								.getValue(), entry.getValue()));
			}
		}
		//healthRecord.setRelationship("");
		return response;
	}

	public HealthHistoryRecord prepareHealthHistoryRecord(
			HealthHistoryRecord healthHistoryRecord) {
		healthHistoryRecord.setUserprofileId(getUserProfileId());
		
		if(healthHistoryRecord.getFirstName()==null) {
			healthHistoryRecord.setFirstName("");
		}
		
		if(healthHistoryRecord.getRelationship()==null) {
			healthHistoryRecord.setRelationship("");
		}
	
		// healthHistoryRecord.setOtherHealthIssues(otherHealthIssues);
				
		return healthHistoryRecord;
	}

	public String saveAndAdd() {
		String outcome = null;
		Reader responseReader = null;
		try {
			ResponseUtil response = saveHealthHistoryRecord(responseReader);
			if (response.isSuccess()) {
				outcome = "addFamilyDisplay";
				saveAndAddMessage = true;
				healthHistoryRecords = findHealthHistoryRecords(userprofileId);
				newHealthHistoryRecord = new HealthHistoryRecord();
			}

		} catch (Exception e) {
			log.error("Failed to Save Health History Record record", e);

			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							ERR_PRCS_RQST, ERR_PRCS_RQST));
		} finally {
			responseReader = null;
		}
		return outcome;
	}

	public List<HealthHistoryRecord> getHealthHistoryRecords() {
		return healthHistoryRecords;
	}

	public void setHealthHistoryRecords(
			List<HealthHistoryRecord> healthHistoryRecords) {
		this.healthHistoryRecords = healthHistoryRecords;
	}

	public DataTable getHrTable() {
		return hrTable;
	}

	public void setHrTable(DataTable hRTable) {
		this.hrTable = hRTable;
	}

	public HealthHistoryRecord getSelectedHealthHistoryRecord() {
		return selectedHealthHistoryRecord;
	}

	public void setSelectedHealthHistoryRecord(
			HealthHistoryRecord selectedHealthHistoryRecord) {
		this.selectedHealthHistoryRecord = selectedHealthHistoryRecord;
	}

	public HealthHistoryRecord getNewHealthHistoryRecord() {
		return newHealthHistoryRecord;
	}

	public void setNewHealthHistoryRecord(
			HealthHistoryRecord newHealthHistoryRecord) {
		this.newHealthHistoryRecord = newHealthHistoryRecord;
	}

	public void setSelfRecord(List<HealthHistoryRecord> healthHistoryRecords) {
		boolean selfFound = false;
		for (HealthHistoryRecord record : healthHistoryRecords) {
			if (record.getRelationshipType().equalsIgnoreCase("Self")) {
				selfHealthHistoryRecord = record;
				selfFound = true;
				break;
			}
			if (selfFound) {
				break;
			}
		}
	}

	public String printerFriendlySummary() {
		issueTable = (DataTable) FacesContext.getCurrentInstance()
				.getViewRoot().findComponent("familyForm:healthHistoryList");
		return "printFamilySummary";
	}

	public HealthHistoryRecord getSelfHealthHistoryRecord() {
		return selfHealthHistoryRecord;
	}

	public String getOtherHealthIssue() {
		return otherHealthIssue;
	}

	public void setOtherHealthIssue(String otherHealthIssue) {
		this.otherHealthIssue = otherHealthIssue;
	}

	public DataTable getIssueTable() {
		return issueTable;
	}

	public void setIssueTable(DataTable issueTable) {
		this.issueTable = issueTable;
	}

	public boolean isAddedOtherIssues() {
		return addedOtherIssues;
	}

	public void setAddedOtherIssues(boolean addedOtherIssues) {
		this.addedOtherIssues = addedOtherIssues;
	}

	public boolean isMissingFirstName() {
		return missingFirstName;
	}

	public void setMissingFirstName(boolean missingFirstName) {
		this.missingFirstName = missingFirstName;
	}

	public boolean isMissingRelationship() {
		return missingRelationship;
	}

	public void setMissingRelationship(boolean missingRelationship) {
		this.missingRelationship = missingRelationship;
	}

	
	public void validateIssues( HealthHistoryRecordDTO healthHistoryRecordDTO) {
		Set<String> healthIssuesSet = new HashSet<String>();
		int totalIssues=0;

		// Airway/Breathing Conditions

		if (healthHistoryRecordDTO.getAwAsthma()) {
			healthIssuesSet.add("Asthma");
		}
		if (healthHistoryRecordDTO.getAwBronchitis()) {
			healthIssuesSet.add("Bronchitis");
		}
		if (healthHistoryRecordDTO.getAwCOPD()) {
			healthIssuesSet.add("COPD (Chronic Obstructive Pulmonary Disease)");
		}
		if (healthHistoryRecordDTO.getAwEmphysema()) {
			healthIssuesSet.add("Emphysema");
		}
		if (healthHistoryRecordDTO.getAwPneumonia()) {
			healthIssuesSet.add("Pneumonia");
		}
		if (healthHistoryRecordDTO.getAwSoB()) {
			healthIssuesSet.add("Shortness of Breath");
		}
		if (healthHistoryRecordDTO.getAwTuberculosis()) {
			healthIssuesSet.add("Tuberculosis");
		}
		if (healthHistoryRecordDTO.getAwOther()) {
			healthIssuesSet.add("Other");
		}

		// Allergy/Immune System Conditions

		if(healthHistoryRecordDTO.getAlAllergies()) {
			healthIssuesSet.add("Allergies");
		}
		if(healthHistoryRecordDTO.getAlLupus()) {
			healthIssuesSet.add("Lupus");
		}
		if(healthHistoryRecordDTO.getAlOther()) {
			healthIssuesSet.add("Other");
		}

		// Alcohol Conditions
		if (healthHistoryRecordDTO.getAlcSocial()) {
			healthIssuesSet.add("Social");
		}
		if (healthHistoryRecordDTO.getAlcOneDrink()) {
			healthIssuesSet.add("1 beer/wine a day");
		}
		if (healthHistoryRecordDTO.getAlcSixDrinks()) {
			healthIssuesSet.add(">6 beers/wines a day");
		}
		if (healthHistoryRecordDTO.getAlcTwoShots()) {
			healthIssuesSet.add(">2 shots a day");
		}

		// Blood Disorders

		if (healthHistoryRecordDTO.getBlAnemia()) {
			healthIssuesSet.add("Anemia");
		}
		if (healthHistoryRecordDTO.getBlBruising()) {
			healthIssuesSet.add("Bruising");
		}
		if (healthHistoryRecordDTO.getBlClotting()) {
			healthIssuesSet.add("Clotting");
		}
		if (healthHistoryRecordDTO.getBlLeukemia()) {
			healthIssuesSet.add("Leukemia");
		}
		if (healthHistoryRecordDTO.getBlSickleCell()) {
			healthIssuesSet.add("Sickle Cell Anemia");
		}
		if (healthHistoryRecordDTO.getBlOther()) {
			healthIssuesSet.add("Other");
		}

		// Body Aches

		if (healthHistoryRecordDTO.getBaArthritis()) {
			healthIssuesSet.add("Arthritis");
		}
		if (healthHistoryRecordDTO.getBaFibromyalgia()) {
			healthIssuesSet.add("Fibromyalgia");
		}
		if (healthHistoryRecordDTO.getBaJointPain()) {
			healthIssuesSet.add("Joint Pain");
		}
		if (healthHistoryRecordDTO.getBaLymeDisease()) {
			healthIssuesSet.add("Lyme Disease");
		}
		if (healthHistoryRecordDTO.getBaOther()) {
			healthIssuesSet.add("Other");
		}

		// Cancers

		if (healthHistoryRecordDTO.getCaBreast()) {
			healthIssuesSet.add("Breast");
		}
		if (healthHistoryRecordDTO.getCaBowel()) {
			healthIssuesSet.add("Bowel");
		}
		if (healthHistoryRecordDTO.getCaColon()) {
			healthIssuesSet.add("Colon");
		}
		if (healthHistoryRecordDTO.getCaLung()) {
			healthIssuesSet.add("Lung");
		}
		if (healthHistoryRecordDTO.getCaOvarian()) {
			healthIssuesSet.add("Ovarian");
		}
		if (healthHistoryRecordDTO.getCaSkin()) {
			healthIssuesSet.add("Skin");
		}
		if (healthHistoryRecordDTO.getCaStomach()) {
			healthIssuesSet.add("Stomach");
		}
		if (healthHistoryRecordDTO.getCaProstate()) {
			healthIssuesSet.add("Prostate");
		}
		if (healthHistoryRecordDTO.getCaOther()) {
			healthIssuesSet.add("Other");
		}

		// Childhood Diseases

		if (healthHistoryRecordDTO.getChChickenPox()) {
			healthIssuesSet.add("Chicken Pox");
		}
		if (healthHistoryRecordDTO.getChDiphtheria()) {
			healthIssuesSet.add("Diphtheria");
		}
		if (healthHistoryRecordDTO.getChMeasles()) {
			healthIssuesSet.add("Measles");
		}
		if (healthHistoryRecordDTO.getChMumps()) {
			healthIssuesSet.add("Mumps");
		}
		if (healthHistoryRecordDTO.getChWhoopingCough()) {
			healthIssuesSet.add("Whooping Cough");
		}
		if (healthHistoryRecordDTO.getChOther()) {
			healthIssuesSet.add("Other");
		}

		// Diabetes
		if (healthHistoryRecordDTO.getDbType1()) {
			healthIssuesSet.add("Type 1");
		}
		if (healthHistoryRecordDTO.getDbType2()) {
			healthIssuesSet.add("Type 2");
		}
		if (healthHistoryRecordDTO.getDbType3()) {
			healthIssuesSet.add("Type 3");
		}

		// Gallbladder
		if (healthHistoryRecordDTO.getGbDisease()) {
			healthIssuesSet.add("Gallbladder Disease");
		}
		if (healthHistoryRecordDTO.getGbStones()) {
			healthIssuesSet.add("Gallstones");
		}
		if (healthHistoryRecordDTO.getGbOther()) {
			healthIssuesSet.add("Other");
		}

		// Head, Eyes, etc.
		
		if(healthHistoryRecordDTO.getHntCataracts()) {
			healthIssuesSet.add("Cataracts");
		}
		if(healthHistoryRecordDTO.getHntDizziness()) {
			healthIssuesSet.add("Dizziness");
		}
		if(healthHistoryRecordDTO.getHntDyslexia()) {
			healthIssuesSet.add("Dyslexia");
		}
		if(healthHistoryRecordDTO.getHntGlaucoma()) {
			healthIssuesSet.add("Glaucoma");		}
		if(healthHistoryRecordDTO.getHntHearingLoss()) {
			healthIssuesSet.add("Hearing Loss");			
		}
		if(healthHistoryRecordDTO.getHntMigraineHeadaches()){
			healthIssuesSet.add("Migraine Headaches");		
		}
		if(healthHistoryRecordDTO.getHntRetinitisPigmentosa()) {
			healthIssuesSet.add("Retinitis Pigmentosa");		}	
		if(healthHistoryRecordDTO.getHntOther()) {
			healthIssuesSet.add("Other");		
		}

		// Heart/Cardiovascular

		if (healthHistoryRecordDTO.getHeAngina()) {
			healthIssuesSet.add("Angina (Pain)");
		}
		if (healthHistoryRecordDTO.getHeCongestiveFailure()) {
			healthIssuesSet.add("Congestive Failure");
		}
		if (healthHistoryRecordDTO.getHeAttack()) {
			healthIssuesSet.add("Heart Attack");
		}
		if (healthHistoryRecordDTO.getHeMurmur()) {
			healthIssuesSet.add("Heart Murmur");
		}
		if (healthHistoryRecordDTO.getHeHighCholesterol()) {
			healthIssuesSet.add("High Blood Cholesterol");
		}
		if (healthHistoryRecordDTO.getHeHighPressure()) {
			healthIssuesSet.add("High Blood Pressure (Hypertension)	");
		}
		if (healthHistoryRecordDTO.getHeMitralValveProlapse()) {
			healthIssuesSet.add("Mitral Valve Prolapse");
		}
		if (healthHistoryRecordDTO.getHeRhythmAbnormality()) {
			healthIssuesSet.add("Rhythm Abnormality (too fast, too slow, palpitations)");
		}
		if (healthHistoryRecordDTO.getHeStroke()) {
			healthIssuesSet.add("Stroke");
		}
		if (healthHistoryRecordDTO.getHeOther()) {
			healthIssuesSet.add("Other");
		}

		// Kidney

		if (healthHistoryRecordDTO.getKiInfections()) {
			healthIssuesSet.add("Infections");
		}
		if (healthHistoryRecordDTO.getKiStones()) {
			healthIssuesSet.add("Kidney Stones");
		}
		if (healthHistoryRecordDTO.getKiRenalFailure()) {
			healthIssuesSet.add("Renal Failure");
		}
		if (healthHistoryRecordDTO.getKiOther()) {
			healthIssuesSet.add("Other");
		}

		// Liver

		if (healthHistoryRecordDTO.getLiHepatitisA()) {
			healthIssuesSet.add("Hepatitis A");
		}
		if (healthHistoryRecordDTO.getLiHepatitisB()) {
			healthIssuesSet.add("Hepatitis B");
		}
		if (healthHistoryRecordDTO.getLiHepatitisC()) {
			healthIssuesSet.add("Hepatitis C");
		}
		if (healthHistoryRecordDTO.getLiCirrhosis()) {
			healthIssuesSet.add("Cirrhosis");
		}
		if (healthHistoryRecordDTO.getLiOther()) {
			healthIssuesSet.add("Other");	
		}

		// Mood/Cognitive

		if (healthHistoryRecordDTO.getMdAnxiety()) {
			healthIssuesSet.add("Anxiety");
		}
		if (healthHistoryRecordDTO.getMdBipolar()) {
			healthIssuesSet.add("Bipolar");
		}
		if (healthHistoryRecordDTO.getMdDepression()) {
			healthIssuesSet.add("Depression");
		}
		if (healthHistoryRecordDTO.getMdParanoia()) {
			healthIssuesSet.add("Paranoia");
		}
		if (healthHistoryRecordDTO.getMdPTSD()) {
			healthIssuesSet.add("PTSD (Post Traumatic Stress Disorder)");
		}
		if (healthHistoryRecordDTO.getMdSchizophrenia()) {
			healthIssuesSet.add("Schizophrenia");
		}
		if (healthHistoryRecordDTO.getMdOther()) {
			healthIssuesSet.add("Other");
		}

		// Nerve

		if (healthHistoryRecordDTO.getNvEpilepsy()) {
			healthIssuesSet.add("Epilepsy");
		}
		if (healthHistoryRecordDTO.getNvMultipleSclerosis()) {
			healthIssuesSet.add("Multiple Sclerosis");
		}
		if (healthHistoryRecordDTO.getNvNumbness()) {
			healthIssuesSet.add("Numbness");
		}
		if (healthHistoryRecordDTO.getNvParalysis()) {
			healthIssuesSet.add("Paralysis");
		}
		if (healthHistoryRecordDTO.getNvSeizures()) {
			healthIssuesSet.add("Seizures (Not Epilepsy)");
		}
		if (healthHistoryRecordDTO.getNvOther()) {
			healthIssuesSet.add("Other");
		}

		// Nose Bleeds
		if (healthHistoryRecordDTO.getNbOnePerMonth()) {
			healthIssuesSet.add(">1/month");
		}
		if (healthHistoryRecordDTO.getNbOnePerWeek()) {
			healthIssuesSet.add(">1/week");
		}
		if (healthHistoryRecordDTO.getNbOnePerDay()) {
			healthIssuesSet.add(">1/day");
		}

		// Pain

		if (healthHistoryRecordDTO.getPnBack()) {
			healthIssuesSet.add("Back");
		}
		if (healthHistoryRecordDTO.getPnJoint()) {
			healthIssuesSet.add("Joint");
		}
		if (healthHistoryRecordDTO.getPnMuscle()) {
			healthIssuesSet.add("Muscle");
		}
		if (healthHistoryRecordDTO.getPnLeg()) {
			healthIssuesSet.add("Leg pain walking long distances");
		}
		if (healthHistoryRecordDTO.getPnOther()) {
			healthIssuesSet.add("Other");
		}

		// Skin Disorders

		if (healthHistoryRecordDTO.getSkEczema()) {
			healthIssuesSet.add("Eczema");
		}
		if (healthHistoryRecordDTO.getSkPsoriasis()) {
			healthIssuesSet.add("Psoriasis");
		}
		if (healthHistoryRecordDTO.getSkOther()) {
			healthIssuesSet.add("Other");
		}

		// Sleep Disorders
		if (healthHistoryRecordDTO.getSlInsomnia()) {
			healthIssuesSet.add("Insomnia");
		}
		if (healthHistoryRecordDTO.getSlApnea()) {
			healthIssuesSet.add("Sleep Apnea");
		}
		if (healthHistoryRecordDTO.getSlOther()) {
			healthIssuesSet.add("Other");
		}

		// Smoking History

		if (healthHistoryRecordDTO.getSmCurrent()) {
			healthIssuesSet.add("Current");
		}
		if (healthHistoryRecordDTO.getSmOnePackPerDay()) {
			healthIssuesSet.add(">1 pack/day");
		}
		if (healthHistoryRecordDTO.getSmTenYears()) {
			healthIssuesSet.add(">10 Years");
		}
		if (healthHistoryRecordDTO.getSmTwentyYears()) {
			healthIssuesSet.add(">20 Years");
		}

		// STDs

		if (healthHistoryRecordDTO.getStdChlamydia()) {
			healthIssuesSet.add("Chlamydia");
		}
		if (healthHistoryRecordDTO.getStdGonorrhea()) {
			healthIssuesSet.add("Gonorrhea");
		}
		if (healthHistoryRecordDTO.getStdHerpes()) {
			healthIssuesSet.add("Herpes");
		}
		if (healthHistoryRecordDTO.getStdSyphilis()) {
			healthIssuesSet.add("Syphilis");
		}
		if (healthHistoryRecordDTO.getStdOther()) {
			healthIssuesSet.add("Other");
		}

		// Stomach, Bowel
		if (healthHistoryRecordDTO.getStmIBS()) {
			healthIssuesSet.add("Irritable Bowel Syndrome");
		}
		if (healthHistoryRecordDTO.getStmNausea()) {
			healthIssuesSet.add("Nausea");
		}
		if (healthHistoryRecordDTO.getStmPain()) {
			healthIssuesSet.add("Pain");
		}
		if (healthHistoryRecordDTO.getStmSevereIndigestion()) {
			healthIssuesSet.add("Severe Indigestion");
		}
		if (healthHistoryRecordDTO.getStmUlcers()) {
			healthIssuesSet.add("Ulcers");
		}
		if (healthHistoryRecordDTO.getStmOther()) {
			healthIssuesSet.add("Other");
		}

		// Thyroid
		if (healthHistoryRecordDTO.getThGoiter()) {
			healthIssuesSet.add("Goiter");
		}
		if (healthHistoryRecordDTO.getThTumor()) {
			healthIssuesSet.add("Tumor");
		}
		if (healthHistoryRecordDTO.getThOther()) {
			healthIssuesSet.add("Other");
		}

		// Weight

		if (healthHistoryRecordDTO.getWtOverweight()) {
			healthIssuesSet.add("Overweight");
		}
		if (healthHistoryRecordDTO.getWtUnderweight()) {
			healthIssuesSet.add("Underweight");
		}

		healthIssuesSet.addAll(healthIssuesSet);
		totalIssues = healthIssuesSet.size() + healthHistoryRecordDTO.getOtherHealthIssues().size();
		if(!otherHealthIssue.isEmpty() && otherHealthIssue!=null) {
			totalIssues++;
		}
		if (totalIssues == 0) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"At least one health issue checkbox must be checked or one other health issue added.",
							"healthIssue"));
		}
		}
	
	
	/**
	 * @return the otherHealthIssues
	 */
	/*
	 * public List<OtherHealthIssueDTO> getOtherHealthIssues() { return
	 * otherHealthIssues; }
	 *//**
	 * @param otherHealthIssues
	 *            the otherHealthIssues to set
	 */
	/*
	 * public void setOtherHealthIssues(List<OtherHealthIssueDTO>
	 * otherHealthIssues) { this.otherHealthIssues = otherHealthIssues; }
	 */

}
